﻿' Developed by Cat333Pokémon
' http://victoryroad.net

Public Class Form1

    Public Sub Trial(ByVal trials As ULong)
        'Set display objects
        Me.Cursor = Cursors.WaitCursor
        prog_trials.Value = 0
        prog_trials.Maximum = trials


        'list_results.Items.Clear()
        Dim foundshiny As Boolean = False
        Dim iterations As ULong = 0

        For i As ULong = 1 To trials 'Run each until a shiny is found
            foundshiny = False
            iterations = 0
            'Display status
            Me.Text = "(" & FormatNumber(trials - i, 0, , , TriState.True) & " rem.) Shiny Sim"
            While foundshiny = False
                For j = 1 To num_prob.Value
                    'Every event is independent
                    If (Rnd() < 1 / 4096.0) Then foundshiny = True
                Next j
                iterations += 1
            End While
            'Shiny found, add trial to list
            list_results.Items.Add(iterations)
            prog_trials.Value = i

        Next

        'Restore state
        Me.Text = "Shiny Sim"
        Me.Cursor = Cursors.Default
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'Initialize RNG
        Randomize()
    End Sub

    Private Sub btn_100_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_100.Click
        Trial(100)
        btn_copy.Enabled = True
    End Sub

    Private Sub btn_1000_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_1000.Click
        Dim boxinput As ULong
        ULong.TryParse(InputBox("How many trials?", , 1000), boxinput)

        If boxinput > 0 Then
            Trial(boxinput)
            btn_copy.Enabled = True
        End If
    End Sub

    Private Sub btn_copy_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_copy.Click
        Dim mystring As String = "" 'Initialize buffer
        For i = 0 To list_results.Items.Count - 1
            mystring &= list_results.Items(i) & vbCrLf 'Add each trial to string
        Next
        My.Computer.Clipboard.SetText(mystring) 'Copy string to clipboard
    End Sub

    Private Sub btn_clear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_clear.Click
        list_results.Items.Clear() 'Wipe list box
        prog_trials.Value = 0
        btn_copy.Enabled = False
    End Sub
End Class
