
#cs --------------------
	Error Message Generator 2
	By SpaceMan
	AutoIt compiler <http://www.autoitscript.com> is required to compile this script.
	
	This script generates a custom error message.
#ce --------------------

#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>

#NoTrayIcon

#Region < Global Variables >
;Global Variables
$_Flag_ = 0
$_Title_ = ""
$_Message_ = ""
#EndRegion

#Region < All controls >

;All Controls
$_ROOT = GUICreate("Error Message Generator", 458, 650, 510, 36)
$_EMG = GUICtrlCreateGroup("Error Message Generator", 8, 8, 441, 633)
$_Flag = GUICtrlCreateGroup("Flag", 16, 24, 425, 401)
$_Button = GUICtrlCreateGroup("Button", 24, 40, 409, 89)
$Radio1 = GUICtrlCreateRadio("OK", 32, 56, 113, 17)
GUICtrlSetState(-1, $GUI_CHECKED)
$Radio2 = GUICtrlCreateRadio("OK and Cancel", 152, 56, 113, 17)
$Radio3 = GUICtrlCreateRadio("About, Retry and Igonre", 272, 56, 137, 17)
$Radio4 = GUICtrlCreateRadio("Yes, No, and Cancel", 32, 80, 121, 17)
$Radio5 = GUICtrlCreateRadio("Yes and No", 152, 80, 113, 17)
$Radio6 = GUICtrlCreateRadio("Retry and Cancel", 272, 80, 113, 17)
$Radio7 = GUICtrlCreateRadio("Cancel, Try Again, Continue", 32, 104, 161, 17)
$Radio8 = GUICtrlCreateRadio("All Buttons", 272, 104, 150, 17)
GUICtrlCreateGroup("", -99, -99, 1, 1)

$_Icon = GUICtrlCreateGroup("Icon", 24, 136, 409, 73)
$Radio11 = GUICtrlCreateRadio("No Icon", 32, 160, 113, 17)
$Radio12 = GUICtrlCreateRadio("Stop Sign", 144, 160, 113, 17)
GUICtrlSetState(-1, $GUI_CHECKED)
$Radio13 = GUICtrlCreateRadio("Question Mark", 272, 160, 113, 17)
$Radio14 = GUICtrlCreateRadio("Exclam. Icon", 32, 184, 113, 17)
$Radio15 = GUICtrlCreateRadio("Info Sign", 144, 184, 113, 17)
GUICtrlCreateGroup("", -99, -99, 1, 1)

$_Default_Btn = GUICtrlCreateGroup("Default Button No.", 24, 216, 409, 49)
$__DefBtn = GUICtrlCreateInput("1", 32, 240, 113, 17)
GUICtrlCreateGroup("", -99, -99, 1, 1)

$_Modality = GUICtrlCreateGroup("Modality", 24, 272, 409, 49)
$Radio31 = GUICtrlCreateRadio("Application", 32, 296, 113, 17)
GUICtrlSetState(-1, $GUI_CHECKED)
$Radio32 = GUICtrlCreateRadio("System", 144, 296, 113, 17)
$Radio33 = GUICtrlCreateRadio("Task", 272, 296, 113, 17)

GUICtrlCreateGroup("", -99, -99, 1, 1)
$_Misc = GUICtrlCreateGroup("Misc", 24, 328, 409, 49)
$Radio41 = GUICtrlCreateRadio("Nothing", 32, 352, 113, 17)
GUICtrlSetState(-1, $GUI_CHECKED)
$Radio42 = GUICtrlCreateRadio("Always on Top", 144, 352, 113, 17)
$Radio43 = GUICtrlCreateRadio("Right-justified", 272, 352, 113, 17)
GUICtrlCreateGroup("", -99, -99, 1, 1)

$_CustExpr = GUICtrlCreateCheckbox("Custom Expression", 32, 392, 113, 17)
$_CustExpr_Box = GUICtrlCreateInput("0x00000000", 152, 392, 121, 21)
GUICtrlSetState(-1, $GUI_DISABLE)
GUICtrlCreateGroup("", -99, -99, 1, 1)

$_Texts = GUICtrlCreateGroup("Texts", 16, 432, 425, 153)
$Label1 = GUICtrlCreateLabel("Title:", 56, 456, 27, 17)
$__Title = GUICtrlCreateInput("ERROR", 96, 456, 137, 21)
$Label2 = GUICtrlCreateLabel("Message:", 32, 488, 50, 17)
$__Message = GUICtrlCreateEdit("", 96, 488, 337, 89)
GUICtrlSetData(-1, "Enter the error message here.")
GUICtrlCreateGroup("", -99, -99, 1, 1)

$_LAUNCH = GUICtrlCreateButton("Launch", 16, 592, 427, 41, 0)
GUICtrlSetFont(-1, 12, 800, 0, "Arial Black")
GUICtrlSetBkColor(-1, 0xFF0000)
GUICtrlCreateGroup("", -99, -99, 1, 1)
GUISetState(@SW_SHOW)
#EndRegion

#Region < Main Loop >
;the main loop
While true
	$_Msg = GUIGetMsg()
	Switch $_Msg
		;Exit
		Case $GUI_EVENT_CLOSE
			Exit
		;when the "Custom Expression" is enabled/disabled
		Case $_CustExpr
			If GUICtrlRead($_CustExpr) == $GUI_UNCHECKED Then
				GUICtrlSetState($_CustExpr_Box, $GUI_DISABLE)
			Else
				GUICtrlSetState($_CustExpr_Box, $GUI_ENABLE)
			EndIf

		;launch the error message, the variables will be updates before the MsgBox()
		Case $_LAUNCH
			If GUICtrlRead($_CustExpr) == $GUI_UNCHECKED Then
				$_Flag_ = 0 ;reset the flag

				;get button config
				Select
					Case GUICtrlRead($Radio2) == $GUI_CHECKED
						$_Flag_ += 0x1
					Case GUICtrlRead($Radio3) == $GUI_CHECKED
						$_Flag_ += 0x2
					Case GUICtrlRead($Radio4) == $GUI_CHECKED
						$_Flag_ += 0x3
					Case GUICtrlRead($Radio5) == $GUI_CHECKED
						$_Flag_ += 0x4
					Case GUICtrlRead($Radio6) == $GUI_CHECKED
						$_Flag_ += 0x5
					Case GUICtrlRead($Radio7) == $GUI_CHECKED
						$_Flag_ += 0x6
					Case GUICtrlRead($Radio8) == $GUI_CHECKED
						$_Flag_ += 0x7
					EndSelect

				;get icon config
				Select
					Case GUICtrlRead($Radio12) == $GUI_CHECKED
						$_Flag_ += 0x10
					Case GUICtrlRead($Radio13) == $GUI_CHECKED
						$_Flag_ += 0x20
					Case GUICtrlRead($Radio14) == $GUI_CHECKED
						$_Flag_ += 0x30
					Case GUICtrlRead($Radio15) == $GUI_CHECKED
						$_Flag_ += 0x40
				EndSelect

				;get default button config
				If GUICtrlRead($__DefBtn) * 0x100 > 2303 Then
					GUICtrlSetData($__DefBtn, 9)
				EndIf

				$_Flag_ += GUICtrlRead($__DefBtn) * 0x100

				;get modality config
				Select
					Case GUICtrlRead($Radio32) == $GUI_CHECKED
						$_Flag_ += 0x1000
					Case GUICtrlRead($Radio33) == $GUI_CHECKED
						$_Flag_ += 0x2000
				EndSelect

				;get misc config
				Select
					Case GUICtrlRead($Radio42) == $GUI_CHECKED
						$_Flag_ += 0x40000
					Case GUICtrlRead($Radio43) == $GUI_CHECKED
						$_Flag_ += 0x80000
				EndSelect

			;read the "custom expression" if the $_CustExpr was checked.
			ElseIf GUICtrlRead($_CustExpr) == $GUI_CHECKED Then
				$_Flag_ = GUICtrlRead($_CustExpr_Box)
			EndIf

			;sets the title
			$_Title_ = GUICtrlRead($__Title)

			;sets the error message
			$_Message_ = GUICtrlRead($__Message)

			;launch the error message
			MsgBox($_Flag_, $_Title_, $_Message_)
	EndSwitch
WEnd
#EndRegion
